/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.james.tinkerscalibration.Utils;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ArmorVibratingModifier
extends Modifier
implements OnAttackedModifierHook,
AttributesModifierHook,
InventoryTickModifierHook,
ModifierRemovalHook,
TooltipModifierHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "vibrating_armor");

    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        LivingEntity user = context.getEntity();
        Entity attacker = source.m_7639_();
        if (isDirectDamage && !user.f_19853_.f_46443_ && attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            context.getTinkerData().ifPresent(data -> {
                int effectLevel = Math.min(7, ((TinkerEffect)Utils.vibratingArmorEffect.get()).getLevel(user) + 1);
                ((TinkerEffect)Utils.vibratingArmorEffect.get()).apply(user, 100, effectLevel, true);
                ModDataNBT persistentData = tool.getPersistentData();
                persistentData.putFloat(this.KEY, (float)(effectLevel + 1));
                float angle = attacker.m_146908_() * (float)Math.PI / 180.0f;
                livingAttacker.m_147240_((double)effectLevel, -Math.sin(angle), Math.cos(angle));
            });
        }
    }

    public boolean isArmor(EquipmentSlot slot) {
        return slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        double boost;
        if (this.isArmor(slot) && (boost = (double)tool.getPersistentData().getFloat(this.KEY) * 0.05) != 0.0) {
            consumer.accept(Attributes.f_22279_, new AttributeModifier(UUID.fromString("d16c3510-37fb-49fd-b484-fb12404f4600"), Attributes.f_22279_.m_22087_(), -boost, AttributeModifier.Operation.ADDITION));
        }
    }

    public void onInventoryTick(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull Level world, @Nonnull LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (!world.f_46443_) {
            ModDataNBT persistentData = tool.getPersistentData();
            if (((TinkerEffect)Utils.vibratingArmorEffect.get()).getLevel(holder) == -1) {
                persistentData.remove(this.KEY);
            }
        }
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove((ResourceLocation)this.getId());
        return null;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.ARMOR);
        if (harvest) {
            float bonus = tool.getPersistentData().getFloat(this.KEY);
            if (player != null && tooltipKey == TooltipKey.SHIFT && bonus > 0.0f) {
                tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.vibrating_armor.knockback").m_130946_(" ").m_130946_(String.valueOf(bonus)).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)15063685))));
            }
        }
    }
}

